/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core.mixin;

import com.minecraftabnormals.environmental.common.item.explorer.ThiefHoodItem;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalAttributes;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"getVisibilityPercent"}, at={@At(value="TAIL")}, cancellable=true)
    private void getVisibilityMultiplier(@Nullable Entity lookingEntity, CallbackInfoReturnable<Double> cir) {
        ItemStack stack;
        Item item;
        double value = (Double)cir.getReturnValue();
        if (lookingEntity != null && (item = (stack = ((LivingEntity)this).func_184582_a(EquipmentSlotType.HEAD)).func_77973_b()) instanceof ThiefHoodItem) {
            Collection modifiers = stack.func_111283_C(EquipmentSlotType.HEAD).get((Object)EnvironmentalAttributes.STEALTH.get());
            if (modifiers.isEmpty()) {
                return;
            }
            double attribute = modifiers.stream().mapToDouble(AttributeModifier::func_111164_d).sum();
            value *= 1.0 - Math.max(attribute, 0.0);
        }
        cir.setReturnValue((Object)value);
    }
}

